import sqlite3

class Pokemon :
    def __init__(self, reponse):
        self.id=reponse[0]
        self.name=reponse[1]
        self.nom=reponse[2]
        self.pv=reponse[3]
        self.attaque=reponse[4]
        self.defense=reponse[5]
        self.attaque_speciale=reponse[6]
        self.defense_speciale=reponse[7]
        self.vitesse=reponse[8]
        self.description=reponse[10]
        self.trouve_evolution_de(reponse[9])
    
    def trouve_evolution_de(self, numero_pokemon_evolution_de):
        if numero_pokemon_evolution_de!=None:
            bdd = creer_connection("pokemon.db")
            # creation du curseur de la connexion
            curseur = bdd.cursor()
            # recherche du pokemon source de l'évolution
            # Ecriture de la requête
            requete=f"""SELECT pokemon.nom FROM pokemon WHERE pokemon.id="{numero_pokemon_evolution_de}";"""
            # Envoi de la requete
            curseur.execute(requete)
            # On applique la méthode fetchone()
            reponse2=curseur.fetchone()
            bdd.close()
            # On affecte l'attribut
            self.evolution_de=reponse2[0]
        else:
            self.evolution_de="---"





# ###########################################
#    Base données                           #
# ###########################################

# Création de la connexion
def creer_connection(db_fichier):
    """
    Crée une connection à une base de données spécifiée dans l'argument db_fichier
    :param db_fichier:
        chemin du fichier de la base de données sous la forme d'une chaine de caractères
    :return:
        objet de connection or None
    """
    connexion = None
    try:
        connexion = sqlite3.connect(db_fichier)
        return connexion
    except Error as e:
        print(e)
        return None

def obtenir_une_reponse(requete):
    bdd = creer_connection("pokemon.db")
    curseur = bdd.cursor()
    curseur.execute(requete)
    reponse=curseur.fetchone()
    curseur.close()
    bdd.close()
    return reponse

def obtenir_plusieurs_reponses(requete):
    bdd = creer_connection("pokemon.db")
    curseur = bdd.cursor()
    curseur.execute(requete)
    reponse=curseur.fetchall()
    curseur.close()
    bdd.close()
    return reponse

# fonction de recherche de la liste des pokemons disponibles
def recherche_pokemons():
    '''
    renvoie la liste des pokemons de la base rangé par ordre alphabetique
    arguments:
        aucun
    return:
        list
    exemple
        return = ['Abo', 'Abra', 'Absol', 'Aflamanoir'......]
    '''    
    requete = "SELECT pokemon.nom FROM pokemon ORDER BY pokemon.nom;"
    reponse=obtenir_plusieurs_reponses(requete)
    # transformation de reponse en liste
    liste=[]
    for i in reponse:
        if i[0]!='NULL':
            liste.append(i[0])
    return liste

# fonction de recherche du nombre de Pokemons dans le pokedex
def nombre_pokemons():
    """
    renvoie le nombre de pokemons presents dans le pokedex
    return: int
    exemple:
         nombre_pokemons=893
    """
    requete = "SELECT COUNT(*) FROM pokemon ;"
    reponse=obtenir_une_reponse(requete)
    nombre_pokemons=reponse[0]
    return nombre_pokemons

# fonction de recherche des attributs d'un pokemon
def recherche_attributs_pokemon(nom_pokemon):
    requete =f"""SELECT * FROM pokemon WHERE pokemon.nom="{nom_pokemon}";"""
    reponse=obtenir_une_reponse(requete)
    return Pokemon(reponse)

# fonction recherche des évolutions du pokemon
def recherche_evolutions(nom_pokemon):
    """
    renvoie la liste des évolutions d'un pokemon
    exemple:
        return =['Aquali', 'Givrali', 'Mentali', 'Noctali', 'Nymphali', 'Phyllali', 'Pyroli', 'Voltali']
    """
    requete=f"""SELECT pokemon.id FROM pokemon WHERE pokemon.nom="{nom_pokemon}";"""
    reponse=obtenir_une_reponse(requete)
    id_pokemon=reponse[0]
    requete=f"""SELECT pokemon.nom FROM pokemon WHERE pokemon.evolution_de={id_pokemon} ORDER BY pokemon.nom"""
    reponse2=obtenir_plusieurs_reponses(requete)
    # creation de la liste des évolutions
    liste_evolutions=[]
    for i in reponse2:
        liste_evolutions.append(i[0])
    return liste_evolutions

def recherche_types(nom_pokemon):
    """
    Cette fonction renvoie la liste des types du pokemon spécifié en argument
    argument:
        nom_pokemon:str
    return:
        list
    exemple:
        liste=['Acier', 'Vol']
    """
    requete=f"""SELECT type.nom
                FROM est_de_type
                INNER JOIN type ON type.id=est_de_type.id_type
                INNER JOIN pokemon on pokemon.id=est_de_type.id_pokemon
                WHERE pokemon.nom="{nom_pokemon}";"""
    reponse=obtenir_plusieurs_reponses(requete)
    liste=[]
    for i in reponse:
        liste.append(i[0])
    return liste